import socket
import json
import pyautogui
import os
import time
import ctypes
import subprocess
import base64
import atexit
from ctypes import wintypes

# 설정
PORT = 3000
BUFFER_SIZE = 1024
MAX_TEXT_LENGTH = 10000  # 최대 텍스트 길이 제한 (안전장치)

# 안전장치 해제
pyautogui.FAILSAFE = False
pyautogui.PAUSE = 0.01

# 한/영 토글 상태 추적
input_mode_korean = False  # False: 영어, True: 한글

print(f"🚀 [윈도우용] 슈퍼 미니키보드 서버 V12 (관리자권한 필수) (Port: {PORT})")
print("⚠️ 필독: 이 창을 [관리자 권한]으로 실행하지 않으면 메모장 입력/스크린샷이 안 됩니다!")

# UDP 소켓 설정
sock = socket.socket(socket.AF_INET, socket.SOCK_DGRAM)
try:
    sock.bind(('0.0.0.0', PORT))
    sock.setblocking(False)
except OSError as e:
    print(f"❌ 포트 {PORT} 바인딩 실패: {e}")
    print("⚠️ 다른 프로그램이 포트를 사용 중이거나 권한이 부족합니다.")
    exit(1)

# 프로그램 종료 시 소켓 정리
def cleanup():
    try:
        sock.close()
        print("\n✅ 서버 종료됨")
    except:
        pass

atexit.register(cleanup)

# ★ [핵심] 텍스트 입력 (직접 입력 방식 - 영문/숫자만)
def type_text(text):
    try:
        # 입력 길이 체크 (안전장치)
        if len(text) > MAX_TEXT_LENGTH:
            print(f"⚠️ 텍스트가 너무 깁니다 ({len(text)}자). 최대 {MAX_TEXT_LENGTH}자까지 지원합니다.")
            text = text[:MAX_TEXT_LENGTH]
        
        # 한글 체크: 한글이 포함되어 있으면 클립보드 방식으로 전환
        has_korean = any('\uac00' <= char <= '\ud7a3' for char in text)
        if has_korean:
            paste_text(text)
            return
        
        # pyautogui.typewrite는 직접 키보드 입력을 시뮬레이션합니다
        # 활성 창으로 입력이 전달됩니다 (영문/숫자만)
        pyautogui.typewrite(text, interval=0.01)
        print(f"✅ 텍스트 입력됨: {text}")
    except Exception as e:
        print(f"⚠️ 텍스트 입력 실패: {e}")
        # 실패 시 클립보드 방식으로 폴백
        paste_text(text)

# ★ [보조] 텍스트 입력 (Ctrl+V - 한글이나 특수문자용) - PowerShell 사용
def paste_text(text):
    try:
        # 입력 길이 체크 (안전장치)
        if len(text) > MAX_TEXT_LENGTH:
            print(f"⚠️ 텍스트가 너무 깁니다 ({len(text)}자). 최대 {MAX_TEXT_LENGTH}자까지 지원합니다.")
            text = text[:MAX_TEXT_LENGTH]
        
        # PowerShell을 사용하여 클립보드에 텍스트 설정 (가장 안정적)
        # Base64로 인코딩하여 특수문자 문제 회피
        text_bytes = text.encode('utf-8')
        text_b64 = base64.b64encode(text_bytes).decode('ascii')
        
        # PowerShell 명령어 생성 (Base64 디코딩 후 클립보드에 설정)
        ps_command = f'''
        $bytes = [System.Convert]::FromBase64String("{text_b64}")
        $text = [System.Text.Encoding]::UTF8.GetString($bytes)
        Set-Clipboard -Value $text
        '''
        
        # PowerShell 실행
        process = subprocess.Popen(
            ['powershell', '-Command', ps_command],
            stdout=subprocess.PIPE,
            stderr=subprocess.PIPE,
            stdin=subprocess.PIPE,
            creationflags=subprocess.CREATE_NO_WINDOW  # 창이 뜨지 않도록
        )
        
        # 타임아웃 설정 (1초)
        try:
            stdout, stderr = process.communicate(timeout=1)
            if process.returncode != 0:
                error_msg = stderr.decode('utf-8', errors='ignore') if stderr else "알 수 없는 오류"
                raise Exception(f"PowerShell 실패: {error_msg}")
        except subprocess.TimeoutExpired:
            process.kill()
            raise Exception("PowerShell 타임아웃")
        
        # 클립보드 설정 후 짧은 대기
        time.sleep(0.05)
        
        # 붙여넣기 실행
        pyautogui.hotkey('ctrl', 'v')
        print(f"✅ 붙여넣기 실행됨: {text}")
        
    except Exception as e:
        # PowerShell 실패 시 Windows API로 폴백
        print(f"⚠️ PowerShell 실패, API 방식 시도: {e}")
        paste_text_api(text)

# Windows API 방식 (폴백)
def paste_text_api(text):
    hMem = None
    try:
        CF_UNICODETEXT = 13
        GMEM_MOVEABLE = 0x0002
        
        # UTF-16 LE로 인코딩
        text_utf16 = text.encode('utf-16-le')
        text_bytes = text_utf16 + b'\x00\x00'
        size = len(text_bytes)
        
        if size == 0:
            raise Exception("텍스트 크기가 0입니다")
        
        kernel32 = ctypes.windll.kernel32
        user32 = ctypes.windll.user32
        
        # 메모리 할당
        hMem = kernel32.GlobalAlloc(GMEM_MOVEABLE, size)
        if not hMem:
            raise Exception("GlobalAlloc 실패")
        
        # 메모리 잠금
        pMem = kernel32.GlobalLock(hMem)
        if not pMem:
            kernel32.GlobalFree(hMem)
            raise Exception("GlobalLock 실패")
        
        try:
            # 메모리에 데이터 복사
            ctypes.memmove(ctypes.c_void_p(pMem), text_bytes, size)
        finally:
            kernel32.GlobalUnlock(hMem)
        
        # 클립보드 설정
        success = False
        for attempt in range(5):
            if user32.OpenClipboard(None):
                try:
                    user32.EmptyClipboard()
                    result = user32.SetClipboardData(CF_UNICODETEXT, hMem)
                    if result:
                        success = True
                        hMem = None
                    else:
                        kernel32.GlobalFree(hMem)
                        hMem = None
                finally:
                    user32.CloseClipboard()
                
                if success:
                    break
            if attempt < 4:
                time.sleep(0.01)
        
        # 붙여넣기 실행
        if success:
            time.sleep(0.02)
            pyautogui.hotkey('ctrl', 'v')
            print(f"✅ 붙여넣기 실행됨 (API): {text}")
        else:
            raise Exception("클립보드 설정 실패")
            
    except Exception as e: 
        print(f"⚠️ 붙여넣기 실패: {e}")
        if hMem:
            try:
                ctypes.windll.kernel32.GlobalFree(hMem)
            except:
                pass

def get_local_ip():
    try:
        s = socket.socket(socket.AF_INET, socket.SOCK_DGRAM)
        s.connect(("8.8.8.8", 80))
        ip = s.getsockname()[0]; s.close(); return ip
    except: return "127.0.0.1"

def open_app(command):
    try:
        if command == "explorer": os.startfile("explorer")
        elif command == "terminal": os.system("start cmd")
        elif "browser" in command: os.system("start https://www.google.com")
        elif command in ["notepad", "new_text_document", "notes"]: os.system("start notepad")
        elif command == "taskmgr": pyautogui.hotkey('ctrl', 'shift', 'esc')
        elif command == "shutdown": os.system("shutdown /s /t 0")
        elif command == "restart": os.system("shutdown /r /t 0")
    except: pass

print(f"✅ 내 IP 주소: {get_local_ip()}")
print("✅ 서버 준비 완료. 아이폰에서 연결하세요.")

while True:
    try:
        try:
            data, addr = sock.recvfrom(BUFFER_SIZE)
        except BlockingIOError:
            time.sleep(0.001)
            continue
            
        decoded_data = data.decode('utf-8')
        
        if "ping" in decoded_data: sock.sendto("pong".encode('utf-8'), addr); continue
        if "scan" in decoded_data:
            hostname = socket.gethostname(); my_ip = get_local_ip()
            response = f"device_info:{hostname}|{my_ip}|win"
            sock.sendto(response.encode('utf-8'), addr)
            print(f"📡 스캔 요청 응답: {response} -> {addr[0]}:{addr[1]}")
            continue

        try:
            json_data = json.loads(decoded_data)
            cmd_type = json_data.get('type')
            
            # 스캔 요청 처리 (JSON 형태)
            if cmd_type == "scan":
                hostname = socket.gethostname(); my_ip = get_local_ip()
                response = f"device_info:{hostname}|{my_ip}|win"
                sock.sendto(response.encode('utf-8'), addr)
                print(f"📡 스캔 요청 응답 (JSON): {response} -> {addr[0]}:{addr[1]}")
                continue
            
            # 1. 특수 기능 키
            if cmd_type == "backspace" or cmd_type == "clear": 
                pyautogui.press('backspace')
                print(f"✅ Backspace 실행됨")
            elif cmd_type == "delete" or cmd_type == "117": pyautogui.press('delete')
            elif cmd_type == "home" or cmd_type == "115": pyautogui.hotkey('ctrl', 'home') 
            elif cmd_type == "end" or cmd_type == "119": pyautogui.hotkey('ctrl', 'end')
            elif cmd_type in ["page_up", "116"]: pyautogui.press('pageup')
            elif cmd_type in ["page_down", "121"]: pyautogui.press('pagedown')
            elif cmd_type == "enter": pyautogui.press('enter')
            elif cmd_type == "space": pyautogui.press('space')
            elif cmd_type == "tab": pyautogui.press('tab')
            elif cmd_type == "esc": pyautogui.press('esc')
            elif cmd_type in ["up", "down", "left", "right"]: pyautogui.press(cmd_type)
            # 한/영 토글
            elif cmd_type == "toggle_lang" or cmd_type == "toggle_korean" or cmd_type == "한/영":
                input_mode_korean = not input_mode_korean
                mode_text = "한글" if input_mode_korean else "영어"
                print(f"✅ 입력 모드 변경: {mode_text}")
            # 화면 잠금
            elif cmd_type == "lock" or cmd_type == "lock_screen":
                pyautogui.hotkey('win', 'l')
                print(f"✅ 화면 잠금 실행됨")

            # 2. 마우스 / 스크롤
            elif cmd_type == "mouse_down": pyautogui.mouseDown()
            elif cmd_type == "mouse_up": pyautogui.mouseUp()
            elif cmd_type == "move": pyautogui.moveRel(json_data.get('dx', 0), json_data.get('dy', 0), _pause=False)
            elif cmd_type == "click": pyautogui.click()
            elif cmd_type == "right_click": pyautogui.click(button='right')
            elif cmd_type == "middle_click": pyautogui.click(button='middle')
            elif cmd_type == "scroll":
                dy = json_data.get('dy', 0)
                if dy == -100: pyautogui.press('down')
                elif dy == 100: pyautogui.press('up')
                else: pyautogui.scroll(dy * 2)
            elif cmd_type == "zoom_in": pyautogui.hotkey('ctrl', '+')
            elif cmd_type == "zoom_out": pyautogui.hotkey('ctrl', '-')

            # 3. 윈도우 기능
            elif cmd_type == "prev_tab": pyautogui.hotkey('ctrl', 'shift', 'tab')
            elif cmd_type == "next_tab": pyautogui.hotkey('ctrl', 'tab')
            elif cmd_type == "new_tab" or cmd_type == "새 탭":
                pyautogui.hotkey('ctrl', 't')
                print(f"✅ 새 탭 열기 실행됨")
            elif cmd_type == "mission_control" or cmd_type == "task_view": pyautogui.hotkey('win', 'tab')
            elif cmd_type == "show_desktop": pyautogui.hotkey('win', 'd')
            elif cmd_type == "switch_app": pyautogui.hotkey('alt', 'tab')
            elif cmd_type == "play": pyautogui.press('space')
            elif cmd_type == "rewind_10": pyautogui.press('left')
            elif cmd_type == "forward_10": pyautogui.press('right')
            elif cmd_type == "prev_video": pyautogui.hotkey('shift', 'p')
            elif cmd_type == "next_video": pyautogui.hotkey('shift', 'n')
            elif cmd_type == "mute": pyautogui.press('volumemute')
            elif cmd_type == "vol_up": pyautogui.press('volumeup')
            elif cmd_type == "vol_down": pyautogui.press('volumedown')
            
            # 4. 편집키
            elif cmd_type == "copy": pyautogui.hotkey('ctrl', 'c')
            elif cmd_type == "paste": pyautogui.hotkey('ctrl', 'v')
            elif cmd_type == "cut": pyautogui.hotkey('ctrl', 'x')
            elif cmd_type == "save": pyautogui.hotkey('ctrl', 's')
            elif cmd_type == "undo": pyautogui.hotkey('ctrl', 'z')
            elif cmd_type == "redo": pyautogui.hotkey('ctrl', 'y')
            elif cmd_type == "select_all": pyautogui.hotkey('ctrl', 'a')
            elif cmd_type == "find": pyautogui.hotkey('ctrl', 'f')
            elif cmd_type == "close_window" or cmd_type == "close_tab": pyautogui.hotkey('ctrl', 'w')
            elif cmd_type == "fullscreen": pyautogui.press('f')
            elif cmd_type == "go_back": pyautogui.hotkey('alt', 'left')
            elif cmd_type == "screenshot_full": pyautogui.press('printscreen')
            elif cmd_type == "screenshot_part": pyautogui.hotkey('win', 'shift', 's')
            
            # 앱 실행
            elif cmd_type in ["explorer", "terminal", "browser", "browser_chrome", "browser_edge", "notepad", "taskmgr", "new_text_document", "notes", "shutdown", "restart"]:
                open_app(cmd_type)
            
            # 5. 텍스트 처리
            else:
                command = str(cmd_type)
                print(f"📩 수신된 텍스트: {command}")

                # 조합키 확인
                command_lower = command.lower()
                if "cmd" in command_lower or "ctrl" in command_lower or "alt" in command_lower or "win" in command_lower or "+" in command_lower:
                    cmd_fixed = command_lower.replace("cmd", "ctrl").replace("command", "ctrl").replace("win", "ctrl").replace("opt", "alt")
                    keys = cmd_fixed.split('+')
                    try: pyautogui.hotkey(*keys)
                    except: pass
                else:
                    # ★ 수정: 한/영 모드에 따른 처리
                    # 한글 모드이거나 텍스트에 한글이 포함된 경우 클립보드 방식
                    if input_mode_korean:
                        # 한글 모드: 항상 클립보드 방식 사용
                        paste_text(command)
                    else:
                        # 영어 모드: 한글 감지 및 처리
                        has_korean = any('\uac00' <= char <= '\ud7a3' for char in command)
                        has_hangul_jamo = any('\u1100' <= char <= '\u11ff' or '\u3130' <= char <= '\u318f' for char in command)
                        
                        if has_korean or has_hangul_jamo or len(command) > 50:
                            # 한글이 있거나 긴 텍스트는 클립보드 방식
                            paste_text(command)
                        else:
                            # 영문/숫자/일반 문자는 직접 입력
                            type_text(command)

        except json.JSONDecodeError: pass
    except Exception as e: print(f"⚠️ 에러: {e}")